<?php 
date_default_timezone_set('Asia/Jakarta');
$tgl = date('d-m-Y H:i:s');

error_reporting(E_ALL);
session_start();
$logkanwil = $_SESSION["logkanwil"]; 

if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

require 'functions.php';

if ($logkanwil == "") {
    header("Location: login.php");
    exit;
}

if (isset($_SESSION["login"]) && ($_SESSION["logkanwil"] != "KP")) {
    header("Location: index.php");
    exit;
}

$kcu = query("SELECT * FROM penilaian_ai ORDER BY nilai");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Data Ramalan AI</title>
    <link rel="shortcut icon" href="idea.png">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Bootstrap 4 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <style>
        body {
            padding: 10px;
            font-family: Arial, sans-serif;
        }
        h1 {
            font-size: 20px;
            text-align: center;
            margin-bottom: 20px;
        }
        .table td, .table th {
            font-size: 14px;
            vertical-align: middle;
        }
        .action-buttons .btn {
            padding: 3px 6px;
            font-size: 13px;
        }
        .btn-icon {
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        @media screen and (max-width: 576px) {
            h1 {
                font-size: 18px;
            }
            .table td, .table th {
                font-size: 13px;
            }
            .btn-sm {
                font-size: 12px;
                padding: 4px 8px;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid">
     <h1>Data Ramalan AI</h1>
    <div class="mb-2 text-center">
        
        <a href="tambah_ramalan_ai.php" class="btn btn-success btn-sm">➕ Tambah</a>
        <a href="logout.php" class="btn btn-danger btn-sm">🔒 Logout</a>
        <a href="index.php" class="btn btn-primary btn-sm">🏠 Home</a>
      <small><?= $tgl; ?> | USER: <?= $logkanwil; ?></small><br>
    </div>

  

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-sm">
            <thead class="thead-dark">
                <tr>
                    <th style="width: 40px;">No</th>
                    <th style="width: 80px;">Aksi</th>
                    <th>Ramalan AI</th>
                </tr>
            </thead>
            <tbody>
            <?php $i = 1; ?>
            <?php foreach ($kcu as $row): ?>
                <tr>
                    <td><?= $i++; ?></td>
                    <td class="action-buttons text-center">
                        <a href="ubah_ramalan_ai.php?id=<?= $row["id"]; ?>" class="btn btn-warning btn-sm btn-icon" title="Ubah">
                            <i class="fas fa-pen"></i>
                        </a>
                        <a href="hapus_ramalan_ai.php?id=<?= $row["id"]; ?>" class="btn btn-danger btn-sm btn-icon" title="Hapus" onclick="return confirm('Anda yakin ingin menghapus?')">
                            <i class="fas fa-trash"></i>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($row["nilai"]); ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>
