<?php 
date_default_timezone_set('Asia/Jakarta');
session_start();
$logkanwil = $_SESSION["logkanwil"];

if (!isset($_SESSION["login"])) {
    header("Location: login.php");
    exit;
}

require 'functions.php';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Data Student</title>
    <link rel="shortcut icon" href="idea.png">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 10px;
        }
        h1 {
            font-size: 20px;
            text-align: center;
        }
        form {
            max-width: 400px;
            margin: auto;
            background: #f9f9f9;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0,0,0,0.1);
        }
        table {
            width: 100%;
        }
        td {
            padding: 6px;
            vertical-align: middle;
        }
        input[type="text"], input[type="file"] {
            width: 100%;
            padding: 6px;
            font-size: 14px;
        }
        button {
            width: 100%;
            padding: 10px;
            font-size: 14px;
        }
        .radio-group {
            display: flex;
            justify-content: space-between;
            padding: 4px 0;
        }
        @media screen and (max-width: 380px) {
            h1 {
                font-size: 18px;
            }
            input[type="text"], button {
                font-size: 12px;
                padding: 6px;
            }
            .radio-group {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>

<div class="mb-2 text-center">
    <span>USER: <?= $logkanwil ?></span>
    <br>
    <a href="logout.php">Logout</a> | 
    <a href="index.php">Home</a>
</div>

<h1>Tambah Data Student</h1>

<form id="formData" enctype="multipart/form-data">
    <table>
        <tr>
            <td><label for="nama">Nama:</label></td>
            <td><input type="text" name="nama" id="nama" required maxlength="20" onkeyup="this.value = this.value.toUpperCase()" autofocus></td>
        </tr>
        <tr>
            <td><label for="sekolah">Nama Sekolah:</label></td>
            <td><input type="text" name="sekolah" id="sekolah" required maxlength="50" onkeyup="this.value = this.value.toUpperCase()"></td>
        </tr>
        <tr>
            <td><label for="kelas">Kelas:</label></td>
            <td><input type="text" name="kelas" id="kelas" required maxlength="5" onkeyup="this.value = this.value.toUpperCase()"></td>
        </tr>
        <tr>
            <td>Gender:</td>    
            <td>
                <label><input type="radio" name="jk" value="Pria" required> Pria</label>
                <label style="margin-left: 15px;"><input type="radio" name="jk" value="Wanita"> Wanita</label>
            </td>
        </tr>
        <tr>
            <td><label for="tgl_lahir">Tgl Lahir: </label></td>
            <td><input required type="date" name="tgl_lahir" id="tgl_lahir"></td>
        </tr>
        <tr>
            <td><label for="wawa">No WA:</label></td>
            <td><input type="text" name="wawa" id="wawa" required maxlength="50" onkeyup="this.value = this.value.toUpperCase()"></td>
        </tr>
        <tr>
            <td><label for="alamat">Alamat Tinggal:</label></td>
            <td><input type="text" name="alamat" id="alamat" required maxlength="50" onkeyup="this.value = this.value.toUpperCase()"></td>
        </tr>
        <tr>
            <td colspan="2">
                <button class="btn btn-danger" type="submit">Konfirmasi</button>
            </td>
        </tr>
    </table>
</form>

<script>
document.getElementById("formData").addEventListener("submit", function(e) {
    e.preventDefault();

    const nama = document.getElementById("nama").value.toUpperCase();
    const kelas = document.getElementById("kelas").value.toUpperCase();
    const alamat = document.getElementById("alamat").value.toUpperCase();
    const wawa = document.getElementById("wawa").value.toUpperCase();
    const sekolah = document.getElementById("sekolah").value.toUpperCase();
    const tgl_lahir = document.getElementById("tgl_lahir").value;
    const jk = document.querySelector('input[name="jk"]:checked')?.value;

    if (!jk) {
        alert("Pilih gender!");
        return;
    }

    fetch("get_ramalan.php")
        .then(response => response.text())
        .then(ramalan => {
            const konfirmasi = confirm(`Konfirmasi Data:\nNama: ${nama}\nSekolah: ${sekolah}\nKelas: ${kelas}\nRamalan AI: ${ramalan}\n\nLanjutkan?`);
            if (konfirmasi) {
                const suara = new Audio(`tts.php?text=Halo adik ${encodeURIComponent(nama)}, sekolah ${encodeURIComponent(sekolah)}, kelas ${encodeURIComponent(kelas)}, ${encodeURIComponent(ramalan)} apakah benar ?&lang=id`);
                suara.play().then(() => {
                    setTimeout(() => {
                        const form = new FormData();
                        form.append("nama", nama);
                        form.append("kelas", kelas);
                        form.append("jk", jk);
                        form.append("wawa", wawa);
                        form.append("alamat", alamat);
                        form.append("tgl_lahir", tgl_lahir);
                        form.append("sekolah", sekolah);
                        form.append("ramalan_ai", ramalan);
                        form.append("simpan", "1");

                        fetch("tambah.php", {
                            method: "POST",
                            body: form
                        }).then(response => response.text())
                          .then(result => {
                            document.open();
                            document.write(result);
                            document.close();
                        });
                    }, 8000);
                });
            } else {
                document.getElementById("nama").focus(); // kembali ke input nama
            }
        });
});
</script>

<?php
if (isset($_POST["simpan"])) {
    if ($_POST["tgl_lahir"] >= date("Y-m-d")) {
        echo "<script>alert('Tanggal lahir harus sebelum hari ini!'); window.location.href = 'tambah.php';</script>";
        exit;
    }

    if (tambah($_POST) > 0) {
        echo "<script>
            alert('Data berhasil ditambahkan!');
            window.location.href = 'index.php';
        </script>";
    } else {
        echo "<script>
            alert('Data gagal ditambahkan!');
            window.location.href = 'tambah.php';
        </script>";
    }
}
?>

</body>
</html>
